// // // // // // // // // // // // // // // //
//
//	ElementListe.cc
//
//	erstellt 15.2.98 von Andreas Warnke
//	geändert 3.5.98 von Andreas Warnke
//



// // // // // // // // // // // // // // // //
//
//	include
//

#include "ElementList.h"



// // // // // // // // // // // // // // // //
//
//	Konstruktor
//

ElementList :: ElementList ()
{
	//	Variablen initialisieren:
	TheFirst = NULL;
	TheLast = NULL;
	TheCount = 0;
	TheFinger = NULL;
};



// // // // // // // // // // // // // // // //
//
//	Destruktor:
//

ElementList :: ~ElementList ()
{
	MakeEmpty ( false );
};



// // // // // // // // // // // // // // // //
//
//	Counter:
//

int ElementList :: CountElements ()
{
	if ( this == NULL )
		return 0;
	else
		return TheCount;
};



// // // // // // // // // // // // // // // //
//
//	Insert:
//

bool ElementList :: Insert ( Element * inElement )
{
	//	Parametercheck:
	if (( this == NULL ) || ( inElement == NULL ))
		return false;
	
	//	Suche eines freien inElement-Platzes:
	int i = 0;
	while ( ( i < _Element_MaxSimLists ) && ( inElement -> TheList [i] != NULL ) )
		i++;
	if ( i >= _Element_MaxSimLists )
		//	Maximale Listenanzahl überschritten.
		return false;
		
	//	Einfügen:
	//
	
	//	Elementzeiger korrigieren:
	inElement -> TheList [i] = this;
	inElement -> TheNext [i] = TheFirst;
	inElement -> TheNextPos [i] = TheFirstPos;
	inElement -> ThePrevious [i] = NULL;
	/*inElement -> ThePreviousPos [i] = -1;*/
	
	//	Zeiger der NAchbArn korrigieren:
	if ( TheFirst != NULL )
	{
		//	nicht leere liste.
		TheFirst -> ThePrevious [TheFirstPos] = inElement;
		TheFirst -> ThePreviousPos [TheFirstPos] = i;
	}
	else
	{
		//	leere Liste:
		TheLast = inElement;
		TheLastPos = i;
	};
	//	TheFirst-Zeiger korrigieren:
	TheFirst = inElement;
	TheFirstPos = i;
	
	//	Counter:
	TheCount++;
	
	//	Finger korrigieren:
	TheFingerListPos++;
	
	//	fertig.
	return true;
};



// // // // // // // // // // // // // // // //
//
//	Remove once:
//

bool ElementList :: Remove ( Element * inElement )
{
	//	Parametercheck:
	if ( ( this == NULL ) || ( inElement == NULL ) )
		return false;
		
	//	ist inElement in der Liste?
	int i = 0;
	while ( ( i < _Element_MaxSimLists ) && ( inElement -> TheList [i] != this ) )
		i++;
	if ( i >= _Element_MaxSimLists )
		//	inElemen t nicht in der Lsite.
		return false;
		
	//	inElement auslesen:
	Element * sNext = inElement -> TheNext [i];
	int sNextPos = inElement -> TheNextPos [i];
	Element * sPrev = inElement -> ThePrevious [i];
	int sPrevPos = inElement -> ThePreviousPos [i];
	
	//	Löschen:
	//
	
	//	Zeiger der Liste korrigieren:
	if ( sNext == NULL )
	{
		//	inElement ist letztes
		TheLast = sPrev;
		TheLastPos = sPrevPos;
	}
	else
	{
		//	inElement ist nicht letztes
		sNext -> ThePrevious [sNextPos] = sPrev;
		sNext -> ThePreviousPos [sNextPos] = sPrevPos;
	};
	if ( sPrev == NULL )
	{
		//	inElement ist erstes:
		TheFirst = sNext;
		TheFirstPos = sNextPos;
	}
	else
	{
		//	inElement ist nicht erstes:
		sPrev -> TheNext [sPrevPos] = sNext;
		sPrev -> TheNextPos [sPrevPos] = sNextPos;
	};
	
	//	in Element die Zeiger freigeben:
	inElement -> TheList [i] = NULL;
	
	//	Counter:
	TheCount --;
	
	//	Finger-List-Position ist ungültig:
	if ( TheFinger == inElement )
	{
		TheFinger = sNext;
		TheFingerPos = sNextPos;
	}
	else if ( TheFinger == sNext )
		TheFingerListPos --;
	else if ( TheFinger == sPrev )
	{
	}
	else
		TheFinger = NULL;
	
	//	fertig:
	return true;
};



// // // // // // // // // // // // // // // //
//	
//	MakeEmpty:
//

void ElementList :: MakeEmpty ( bool inDelete )
{
	//	Parametercheck:
	if ( this == NULL )
		return;
		
	//	Lösche:
	if ( inDelete )
		while ( TheCount > 0 )
			delete TheFirst;
	else
		while ( TheCount > 0 )
			Remove ( TheFirst );
};



// // // // // // // // // // // // // // // //
//	
//	HasElement:
//

bool ElementList :: HasElement ( const Element * inElement )
{
	//	Parametercheck:
	if ( ( this == NULL ) || ( inElement == NULL ) )
		return false;
		
	//	Suche:
	int i = 0;
	while ( i < _Element_MaxSimLists )
	{
		if ( inElement -> TheList [i] == this )
			return true;
		i++;
	};

	//	not found.
	return false;
};



// // // // // // // // // // // // // // // //
//	
//	GetElement:
//

Element * ElementList :: GetElement ( int inPos )
{
	//	PArametercheck:
	if ( ( this == NULL ) || ( inPos < 0 ) || ( inPos >= TheCount ) )
		return NULL;
			
	if (( TheFinger == NULL ) || ( TheFingerListPos > inPos + TheCount / 2) 
		|| ( TheFingerListPos < inPos - TheCount / 2) )
		//	Initialisiere TheFinger:
		if ( inPos > TheCount / 2 )
		{
			//	Suche von rechts:
			TheFinger = TheLast;
			TheFingerPos = TheLastPos;
			TheFingerListPos = TheCount - 1;
		}
		else
		{
			//	Suche von links:
			TheFinger = TheFirst;
			TheFingerPos = TheFirstPos;
			TheFingerListPos = 0;
		};
		
	//	Suche:
	while ( TheFingerListPos < inPos )
	{
		int sCurrentPos = TheFingerPos;
		TheFingerPos = TheFinger -> TheNextPos [sCurrentPos];
		TheFinger = TheFinger -> TheNext [sCurrentPos];
		TheFingerListPos++;
	};
	while ( TheFingerListPos > inPos )
	{
		int sCurrentPos = TheFingerPos;
		TheFingerPos = TheFinger -> ThePreviousPos [sCurrentPos];
		TheFinger = TheFinger -> ThePrevious [sCurrentPos];
		TheFingerListPos --;
	};
	
	//	fertig:
	return TheFinger;
};



//
//	Ende
//
// // // // // // // // // // // // // // // //